const sharp = require("sharp");
const path = require("path");
const fs = require("fs");

const processImage = async (filePath, studentId) => {
  try {
    const webpDir = path.join("uploads", "webp");
    if (!fs.existsSync(webpDir)) {
      fs.mkdirSync(webpDir, { recursive: true });
    }

    // Get filename without extension
    const filename = path.basename(filePath, path.extname(filePath));
    const webpFilename = `${filename}-${studentId}.webp`;
    const webpPath = path.join(webpDir, webpFilename);

    console.log("Processing image to WebP:");
    console.log("Source:", filePath);
    console.log("Destination:", webpPath);
    console.log("Student ID:", studentId);

    // First, check if the file exists and is readable
    if (!fs.existsSync(filePath)) {
      throw new Error(`Source file does not exist: ${filePath}`);
    }

    // Try to read the file first
    const fileStats = fs.statSync(filePath);
    console.log("File size:", fileStats.size, "bytes");

    // Process image with sharp
    await sharp(filePath)
      .resize(500, 500, {
        fit: "cover",
        position: "center",
        withoutEnlargement: true,
      })
      .toFormat("webp", {
        quality: 80,
        effort: 6,
      })
      .toFile(webpPath);

    console.log("Image processed successfully:", webpPath);

    return {
      webpFilename,
      webpPath: `uploads/webp/${webpFilename}`,
    };
  } catch (error) {
    console.error("Image processing error details:", error);
    throw new Error(`Image processing failed: ${error.message}`);
  }
};

module.exports = { processImage };
