const express = require("express");
const router = express.Router();
const dutyController = require("../../controllers/dutyController");

// Teacher routes
router.get("/my-duties", dutyController.getTeacherDuties);
router.get("/duties/statistics", dutyController.getDutyStatistics);
router.get("/duties/by-date", dutyController.getDutiesByDateRange);
router.put("/duties/:dutyId/status", dutyController.updateDutyStatus);

// Admin routes
router.get("/duties/all", dutyController.getAllDuties);
router.delete("/duties/:dutyId", dutyController.deleteDuty);

// Get specific teacher's duties (admin or self)
router.get("/duties/teacher/:teacherId", dutyController.getTeacherDuties);

module.exports = router;
