const { sequelize } = require("./db");
const initModels = require("../models/init-models");

async function setupDatabase() {
  try {
    // Initialize all models
    const models = initModels(sequelize);

    // Sync all models
    await sequelize.sync({ force: false, alter: true });

    console.log("✅ Database setup completed");
    process.exit(0);
  } catch (error) {
    console.error("❌ Database setup failed:", error);
    process.exit(1);
  }
}

setupDatabase();
